@echo off
REM ==============================
REM TeamViewer Assignment Utility
REM ==============================

setlocal enabledelayedexpansion

REM ==============================
REM Configuration
REM ==============================
set "AssignmentID=0001CoABChBOhG0g6vYR7qrqZnJ_ASPrEigIACAAAgAJABBlCawdNzcI8NlWi072Y5XDZ8_PCqWRs6FV7NAazwxUGkADBn9P4HcNaREs20CMHASg-_d4ktj_TAHNjr3f4glyOFYqjjKskIGA7_IezMkP1nTKmQ-TP2_Ph6BkBF5AMIy1IAEQkZKN5gU="

REM Optional silent mode flag
set "SilentMode=false"
if /i "%1"=="-Silent" set "SilentMode=true"

REM ==============================
REM Locate TeamViewer executable
REM ==============================
set "TeamViewerExe=%ProgramFiles%\TeamViewer\TeamViewer.exe"
if not exist "%TeamViewerExe%" set "TeamViewerExe=%ProgramFiles(x86)%\TeamViewer\TeamViewer.exe"

if not exist "%TeamViewerExe%" (
    echo [ERROR] TeamViewer is not installed on this system.
    exit /b 1
)

echo [INFO] Using TeamViewer executable: "%TeamViewerExe%"

REM ==============================
REM Attempt assignment with retries
REM ==============================
set "MaxAssignmentRetries=2"
set "AssignmentAttempt=0"
set "AssignmentSuccess=false"

:AssignmentLoop
set /a AssignmentAttempt+=1
if !AssignmentAttempt! gtr 1 (
    echo [INFO] Assignment verification attempt !AssignmentAttempt!...
)

echo [INFO] Running TeamViewer assignment...
"%TeamViewerExe%" assignment --id "%AssignmentID%" --device-alias "%COMPUTERNAME%" --timeout 30
set "VerifyExitCode=!errorlevel!"
echo [INFO] Assignment command returned exit code: !VerifyExitCode!

if !VerifyExitCode! equ 0 (
    echo [SUCCESS] Assignment verification successful!
    echo [INFO] Device is properly assigned to your TeamViewer account.
    set "AssignmentSuccess=true"
    goto :AssignmentDone
)
if !VerifyExitCode! equ 409 (
    echo [SUCCESS] Assignment verification successful!
    echo [INFO] Device was already assigned (this is normal).
    set "AssignmentSuccess=true"
    goto :AssignmentDone
)
if !VerifyExitCode! equ 400 (
    echo [ERROR] Assignment verification failed: Invalid Assignment ID.
    goto :AssignmentDone
)
if !VerifyExitCode! equ 403 (
    echo [WARNING] Assignment verification failed: No internet connection.
    if !AssignmentAttempt! leq %MaxAssignmentRetries% (
        echo [INFO] Will retry assignment in 10 seconds...
        timeout /t 10 /nobreak >nul
        goto :AssignmentLoop
    ) else (
        echo [INFO] Assignment will complete when internet is available.
        goto :AssignmentDone
    )
)
if !VerifyExitCode! equ 401 (
    echo [WARNING] Assignment verification failed: TeamViewer service not running properly.
    if !AssignmentAttempt! leq %MaxAssignmentRetries% (
        echo [INFO] Waiting 10 seconds for service to stabilize...
        timeout /t 10 /nobreak >nul
        goto :AssignmentLoop
    )
)

echo [WARNING] Assignment verification returned code: !VerifyExitCode!
if !AssignmentAttempt! leq %MaxAssignmentRetries% (
    echo [INFO] Retrying assignment in 10 seconds...
    timeout /t 10 /nobreak >nul
    goto :AssignmentLoop
) else (
    echo [WARNING] Assignment may still be successful. Check the TeamViewer Management Console.
)

:AssignmentDone
if "%AssignmentSuccess%"=="true" (
    echo [SUCCESS] TeamViewer assignment completed successfully!
    exit /b 0
) else (
    echo [WARNING] Assignment verification inconclusive after !AssignmentAttempt! attempts.
    exit /b 1
)
